<?php

namespace Velis\Db\EntityHook;

use Attribute;

#[Attribute(Attribute::IS_REPEATABLE | Attribute::TARGET_CLASS)]
class HasHook
{
    /**
     * @param class-string $class
     */
    public function __construct(
        private readonly EventType $event,
        private readonly string $class,
        private readonly string $method,
    ) {
    }

    public function getEvent(): EventType
    {
        return $this->event;
    }

    /**
     * @return class-string
     */
    public function getClass(): string
    {
        return $this->class;
    }

    public function getMethod(): string
    {
        return $this->method;
    }
}
