<?php

namespace Velis\Crypto;

use InvalidArgumentException;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class SignatureGenerator
{
    /**
     * @var resource
     */
    private $key;


    /**
     * @param string $privateKeyPath
     */
    public function __construct($privateKeyPath)
    {
        $this->key = openssl_pkey_get_private('file://' . $privateKeyPath);

        if (!$this->key) {
            throw new InvalidArgumentException(sprintf('Failed to open private key. Given path: %s', $privateKeyPath));
        }
    }


    /**
     * @param string $message
     * @return string
     */
    public function sign($message)
    {
        $signature = '';
        openssl_sign($message, $signature, $this->key);

        return base64_encode($signature);
    }
}
