<?php

namespace Velis\Crypt;

use Phalcon\Di\DiInterface;
use Phalcon\Di\ServiceProviderInterface;
use Velis\App;
use Velis\Crypt\Interface\CryptInterface;

final class CryptServiceProvider implements ServiceProviderInterface
{
    public function register(DiInterface $di): void
    {
        $di->setShared(
            name: CryptInterface::class,
            definition: fn () => new Crypt(
                key: base64_decode(App::$config->get('crypt')?->get('appKey'))
            )
        );
    }
}
