<?php

namespace Velis\Command;

use League\Tactician\Handler\MethodNameInflector\ClassNameInflector;

/**
 * Assumes the method is handle or handle + the last portion of the class name.
 *
 * Examples:
 *  - \MyGlobalCommand              => $handler->handleMyGlobalCommand()
 *  - \My\App\TaskCompletedCommand  => $handler->handleTaskCompletedCommand()
 */
class HandleClassNameInflector extends ClassNameInflector
{
    /**
     * {@inheritdoc}
     */
    public function inflect($command, $commandHandler)
    {
        if (method_exists($commandHandler, 'handle')) {
            return 'handle';
        } else {
            $commandName = parent::inflect($command, $commandHandler);
            return 'handle' . ucfirst($commandName);
        }
    }
}
