<?php

namespace Velis\Command;

use League\Tactician\CommandBus as CommandBusBase;
use League\Tactician\Handler\CommandHandlerMiddleware;
use League\Tactician\Handler\CommandNameExtractor\ClassNameExtractor;

/**
 * Command Bus
 * @author Olek Procki <olo@velis.pl>
 */
class CommandBus extends CommandBusBase
{
    /**
     * @param \League\Tactician\Middleware[] $middleware
     */
    public function __construct(array $middleware = null)
    {
        if (!$middleware) {
            // Now, we create our command bus using our container based loader instead
            $middleware = [
                new CommandHandlerMiddleware(
                    new ClassNameExtractor(),
                    new HandlerLocator(),
                    new HandleClassNameInflector()
                )
            ];
        }

        parent::__construct($middleware);
    }
}
