<?php

namespace Velis\Cache;

use DateInterval;
use Psr\Cache\CacheItemInterface;

/**
 * PSR-6 cache item implementation
 * @author Paweł Szołucha <pawel.szolucha@velis.pl>
 */
class Item implements CacheItemInterface
{
    /**
     * CacheItem key
     *
     * @var string
     */
    protected $key;

    /**
     * CacheItem value
     *
     * @var null|string
     */
    protected $value;


    /**
     * CacheItem expiration time
     *
     * @var int|DateInterval|null $time
     */
    protected $expiration = null;

    /**
     * Constructor
     *
     * @param string $key
     * @param null|string $value
     */
    public function __construct($key, $value = null)
    {
        $this->key = $key;
        $this->value = $value;
    }

    /**
     * Returns the key for the current cache item.
     *
     * @return string
     */
    public function getKey()
    {
        return $this->key;
    }

    /**
     * Retrieves the value of the item from the cache associated with this object's key.
     *
     * @return mixed
     */
    public function get()
    {
        return $this->value;
    }

    /**
     * Confirms if the cache item lookup resulted in a cache hit.
     *
     * @return bool
     */
    public function isHit()
    {
        return $this->value !== null;
    }

    /**
     * Sets the value represented by this cache item.
     *
     * @param mixed $value
     * @return Velis\Cache\Item
     */
    public function set($value)
    {
        $this->value = $value;
        return $this;
    }

    /**
     * Sets the expiration time for this cache item.
     *
     * @param \DateTimeInterface|null $expiration
     * @return Velis\Cache\Item
     */
    public function expiresAt($expiration)
    {
    }

    /**
     * Sets the expiration time for this cache item.
     *
     * @param int|null $time
     * @return Velis\Cache\Item
     */
    public function expiresAfter($time)
    {
        if (is_int($time)) {
            $this->expiration = $time;
        } elseif ($time === null) {
            $this->expiration = null;
        }

        return $this;
    }

    /**
     * Returns expiration of the current cache item.
     *
     * @return int|null
     */
    public function getExpiration()
    {
        return $this->expiration;
    }
}
