<?php

namespace Velis\Cache;

use ArrayAccess;
use Psr\SimpleCache\CacheInterface as PsrCacheInterface;

/**
 * Cache interface
 *
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
interface CacheInterface extends PsrCacheInterface, ArrayAccess
{
    /**
     * Check if cache exists
     *
     * @param string $key
     * @return bool
     * @deprecated use has() method instead
     */
    public function exists($key): bool;

    /**
     * Save value into cache
     *
     * @param string $key
     * @param mixed $value
     * @param int $ttl
     * @return bool
     * @deprecated use set() method instead
     */
    public function save($key, $value, $ttl);

    /**
     * Flush cache
     *
     * @return bool
     * @deprecated use clear() method instead
     */
    public function flush(): bool;

    /**
     * Get profiler array
     *
     * @return array
     */
    public function getProfiler(): array;

    /**
     * Returns all the keys stored. If a filter has been passed the keys that
     * match the filter will be returned
     *
     * @param string $prefix
     * @return array
     */
    public function getKeys(string $prefix = ''): array;
}
