<?php

namespace Velis\Bpm\Workflow;

/**
 * Workflow notification variant
 * @author Olek Procki <olo@velis.pl>
 */
class Notification extends \Velis\Notification
{
    public const WORKFLOW = 'workflow';

    /**
     * Queue via resque
     *
     * @var int
     */
    protected static $_queueMode = self::QUEUE_RESQUE;

    /**
     * Notification mail subject
     * @var string
     */
    protected $_subject;


    /**
     * Notification mail body
     * @var string
     */
    protected $_body;


    /**
     * True jeżeli dana klasa Notification ma wykorzystywać kolejkowanie maili
     *
     * @var bool włączone kolejkowanie maili
     */
    protected static $_queue = true;


    /**
     * Constructor
     *
     * @param string $subject
     * @param string $body
     */
    public function __construct($subject, $body)
    {
        $this->_subject = $subject;
        $this->_body    = $body;
        $this->_type = self::WORKFLOW;

        parent::__construct();
        $this->content = $this->_body;
    }


    /**
     * Returns notification mail subjects
     * @return string
     */
    protected function _getMailSubject()
    {
        return $this->_subject;
    }
}
