<?php

namespace Velis\Bpm\Ticket;

use Velis\Model\DataObject;
use Velis\Model\Cacheable;

/**
 * Ticket type dictionary model
 * @author Olek Procki <olo@velis.pl>
 */
class Type extends DataObject implements Cacheable
{
    /**
     * Default order of types
     * @var string
     */
    protected static $_listDefaultOrder = 'sort_order';


    /**
     * Returns related table name
     * @return string
     */
    protected function _getTableName()
    {
        return 'app.ticket_type_tab';
    }


    /**
     * Returns ticket type name in current application language
     * @return string
     */
    public function getName()
    {
        return $this->getTranslatedName();
    }
}
