<?php

namespace Velis\Bpm\Ticket\Mixin;

use Ticket\Ticket;
use Velis\Bpm\Ticket\Status;
use Velis\Dictionary;

/**
 * Ticket statuses functionality
 * @author Olek Procki <olo@velis.pl>
 */
trait StatusTrait
{
    /**
     * Opened statuses
     * @var Status[]
     */
    protected static $_openedStatuses = null;


    /**
     * Get current ticket status
     * @return Status
     */
    public function getStatus(): Status
    {
        $statuses = static::getStatuses();
        return $statuses[$this->ticket_status_id];
    }


    /**
     * Returns current ticket status id
     * @return string
     */
    public function getStatusId(): string
    {
        return $this->ticket_status_id;
    }


    /**
     * Returns status name
     * @param string $statusId
     * @return string
     */
    public static function getStatusName(string $statusId): string
    {
        $statusList = Dictionary::get('app.ticket_status_tab');
        return $statusList[$statusId];
    }


    /**
     * Returns true if ticket is Opened/Confirmed
     * @return bool
     */
    public function isOpened(): bool
    {
        return in_array($this->ticket_status_id, [Ticket::OPENED, Ticket::CONFIRMED]);
    }


    /**
     * Returns true if ticket is finished
     * @return bool
     */
    public function isFinished(): bool
    {
        return in_array($this->ticket_status_id, [Ticket::CLOSED, Ticket::CANCELLED, 'Exchange']);
    }
}
