<?php

namespace Velis\Bpm\Ticket\Mixin;

use Velis\App;
use Velis\Lang;
use Velis\Bpm\User;
use Velis\Notification\Recipient;

/**
 * Notifications functionality
 * @author Olek Procki <olo@velis.pl>
 */
trait NotificationTrait
{
    /**
     * Recipient will be skipped in getNotificationRecipients method
     * @var Recipient
     */
    protected $_excludeRecipients = [];


    /**
     * Eclude recipients
     * @param Recipient $recipient
     */
    public function excludeRecipient($recipient)
    {
        if ($recipient instanceof Recipient) {
            $this->_excludeRecipients[] = strtolower($recipient->getEmail());
        }
    }


    /**
     * Returns notification recipients list
     * @return \Velis\User[]
     */
    public function getNotificationRecipients()
    {
        $recipients = $this->getObservers();

        if ($this->responsible_user_id) {
            $recipients[$this->responsible_user_id] = $this->getOperator();
        }

        if ($owner = $this->getOwner()) {
            $recipients[$owner->id()] = $owner;
        }

        foreach ($this->getAdditionalNotificationRecipients() as $key => $recipient) {
            $recipients[$key] = $recipient;
        }

        foreach ($recipients as $key => $recipient) {
            if (in_array(strtolower($recipient->getEmail()), $this->_excludeRecipients)) {
                unset($recipients[$key]);
                continue;
            }
            if ($recipient instanceof \Velis\User && !$recipient->isPresent() && $recipient->getSubstitute()) {
                $recipients[$recipient['substitute_user_id']] = $recipient->getSubstitute();
            }
        }

        unset($recipients[App::$user->id()]);

        return $recipients;
    }


    /**
     * Returns additional notification recipients list
     * @return \Velis\User[]
     */
    public function getAdditionalNotificationRecipients()
    {
        return [];
    }


    /**
     * Returns private post notification recipients list
     * @return \Velis\User[]
     */
    public function getPrivatePostRecipients()
    {
        return [];
    }


    /**
     * Returns protected post notification recipients list
     * @return \Velis\Bpm\User[]
     */
    public function getProtectedPostRecipients()
    {
        return array_filter(
            $this->getNotificationRecipients(),
            fn($recipient) => $recipient instanceof User && !$recipient->hasCompany()
        );
    }


    /**
     * Returns html button with href to ticket
     * @return string
     */
    public function getButton()
    {
        $filename = ROOT_PATH . 'module/Application/view/plugin/block.email_container.php';

        if (file_exists($filename)) {
            // This internal config file has its extension - it's declared with variable declaration.
            // @phpcs:ignore
            require_once $filename;

            $repeat = false;
            $params = [
                'type' => 'button',
                'href' => [
                    $this->getUrl()
                ],
                'label' => [
                    Lang::get('GENERAL_GO_TO_TICKET')
                ]
            ];
            return smarty_block_email_container(
                $params,
                null,
                null,
                $repeat
            );
        }
        return '';
    }


    /**
     * Checks if additional information should be added to email notification
     *
     * @param string $event
     * @return boolean
     */
    public function hasAdditionalNotificationInfo($event)
    {
        return false;
    }
}
