<?php

namespace Velis\Bpm\Ticket\Mixin;

use Velis\Lang;

/**
 * Ticket comparation functionality
 * @author Olek Procki <olo@velis.pl>
 */
trait CompareTrait
{
    /**
     * Returns editable fields for diff comparsion
     * @return array
     */
    protected function _getDiffFields()
    {
        return array(
            'Title'                 => '{TICKET_DIFF_TITLE}',
            'DiffCurrentDirection'  => '{TICKET_DIFF_DIRECTION}',
            'DiffCategory'          => '{TICKET_DIFF_CATEGORY}',
            'DiffPriority'          => '{TICKET_DIFF_PRIORITY}',
            'DiffStatus'            => '{TICKET_DIFF_STATUS}',
            'DateConfirmed'         => '{TICKET_DIFF_CONFIRMED_DATE}',
            'Operator'              => '{TICKET_DIFF_OPERATOR}',
            'ResponsibleDepartment' => '{TICKET_DIFF_RESPONSIBLE_DEPARTMENT}',
            'Owner'                 => '{TICKET_DIFF_NOTIFIER}'
        );
    }


    /**
     * Returns current direction description
     * @return string
     */
    public function getDiffCurrentDirection()
    {
        if ($this->direction == '>') {
            return '{TICKET_TO_RESPONSIBLE}';
        } else {
            return '{TICKET_TO_ISSUER}';
        }
    }


    /**
     * Returns status language list
     * @return string
     */
    public function getDiffStatus()
    {
        $sep1 = chr(30);
        $sep2 = chr(31);

        $status = $this->getStatus(true);
        $languageList = Lang::getLanguages();
        $statusString = '[';

        foreach ($languageList as $languageCode => $languageName) {
            $nameLanguage = 'name_' . $languageCode;
            $statusString .= '{' . $languageCode . $sep1 . $status[$nameLanguage] . '}' . $sep2;
        }

        $statusString = substr($statusString, 0, -1);
        $statusString .= ']';
        return $statusString;
    }


    /**
     * Returns categories language list
     * @return string
     */
    public function getDiffCategory()
    {
        $sep1 = chr(30);
        $sep2 = chr(31);

        $category = $this->getCategory();
        $languageList = Lang::getLanguages();
        $categoriesString = '[';

        foreach ($languageList as $languageCode => $languageName) {
            $nameLanguage = 'name_' . $languageCode;
            $categoriesString .= '{' . $languageCode . $sep1 . $category->$nameLanguage . '}' . $sep2;
        }

        $categoriesString = substr($categoriesString, 0, -1);
        $categoriesString .= ']';
        return $categoriesString;
    }


    /**
     * Returns priorities language list
     * @return string
     */
    public function getDiffPriority()
    {
        $sep1 = chr(30);
        $sep2 = chr(31);
        $priority = $this->getPriority();
        $languageList = Lang::getLanguages();
        $priorityString = '[';

        foreach ($languageList as $languageCode => $languageName) {
            $nameLanguage = 'name_' . $languageCode;
            $priorityString .= '{' . $languageCode . $sep1 . $priority->$nameLanguage . '}' . $sep2;
        }

        $priorityString = substr($priorityString, 0, -1);
        $priorityString .= ']';
        return $priorityString;
    }
}
