<?php

namespace Velis\Bpm\Resource;

use Velis\Model\DataObject;

/**
 * Resource service model
 * @author Olek Procki <olo@velis.pl>
 */
class Service extends DataObject
{
    /**
     * Default list order
     * @var string
     */
    protected static $_listDefaultOrder = 'name';


    /**
     * @return string
     */
    protected function _getTableName()
    {
        return 'app.resource_service_tab';
    }


    /**
     * @return string
     */
    public function getName()
    {
        return $this['name'];
    }


    /**
     * Removes resource service
     * @return bool
     */
    public function remove()
    {
        return parent::_remove();
    }
}
