<?php

namespace Velis\Bpm;

use Velis\Model\DataObject;
use Velis\Model\Cacheable;
use InvalidArgumentException;

/**
 * Company department model
 * @author Olek Procki <olo@velis.pl>
 */
class Department extends DataObject implements Cacheable
{
    /**
     * Default order phrase
     * @var string
     */
    protected static $_listDefaultOrder = 'name';


    /**
     * Returns list datasource
     * @return string
     */
    protected function _getListDatasource()
    {
        return 'acl.department d';
    }


    /**
     * @return string
     */
    protected function _getTableName()
    {
        return 'acl.department_tab';
    }


    /**
     * Returns department name
     * @return string
     */
    public function getName()
    {
        return $this->getTranslatedName();
    }


    /**
     * Validate PK format
     * @return bool
     *
     * @throws InvalidArgumentException
     */
    protected function _validate()
    {
        if (!preg_match('/[a-z]+/i', $this->id())) {
            throw new InvalidArgumentException('Niepoprawny format akronimu - dozwolone tylko znaki alfanumeryczne!');
        }
    }


    /**
     * Modifies deparment data
     * @param bool $checkDiff
     */
    public function modify($checkDiff = false)
    {
        $this->_validate();
        parent::modify($checkDiff);
    }


    /**
     * Adds new department
     * @param bool $updateObjectId
     */
    public function add($updateObjectId = false)
    {
        $this->_validate();
        parent::add($updateObjectId);
    }


    /**
     * Removes department
     * @return bool
     */
    public function remove()
    {
        return parent::_remove();
    }

    public function isActive()
    {
        return true;
    }
}
