<?php

namespace Velis\Bpm\Currency;

use Velis\Model\DataObject;

/**
 * Currency rate model
 * @author Olek Procki <olo@velis.pl>
 */
class Rate extends DataObject
{
    /**
     * Invoice2Pdf currencyRates
     * @var array
     */
    protected static $_currencyRatesDates;

    /**
     * Returns related table name
     * @return string
     */
    protected function _getTableName()
    {
        return 'app.currency_rate_tab';
    }

    /**
     * Returns calculated currency rate date by getting the nearest working day
     * @return string
     */
    public static function getCurrencyRateDate($currencyDate)
    {
        if (!self::$_currencyRatesDates[$currencyDate]) {
            $sql = "SELECT max(valid_from) as date FROM app.currency_rate_tab WHERE valid_from <= to_date(:currencyDate, 'YYYY-MM-DD')";
            self::$_currencyRatesDates[$currencyDate] = self::$_db->getOne($sql, ['currencyDate' => $currencyDate]);
        }

        return self::$_currencyRatesDates[$currencyDate];
    }
}
