<?php

namespace Velis\Bpm;

use Velis\Model\DataObject;
use Velis\Model\Cacheable;

/**
 * Currency model
 * @author Bartosz Izdebski <bartosz.izdebski@velis.pl>
 */
class Currency extends DataObject implements Cacheable
{

    protected static $_listDefaultOrder = 'currency_code';
    protected static $_filterListParams = true;

    /**
     * Returns primary key field name for object
     * @return string
     */
    protected function _getPrimaryKeyField()
    {
        return 'currency_code';
    }

    /**
     * Returns related sql table
     * @return string
     */
    protected function _getTableName()
    {
        return 'app.currency_tab';
    }


    /**
     * Returns currency name
     * @return string
     */
    public function getName()
    {
        return $this->currency_code;
    }
}
