<?php

namespace Velis\Auth;

use InvalidArgumentException;
use Laminas\Filter\Decrypt;
use Velis\Auth\Filter\Base64DecryptDecorator;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 * @deprecated Will be removed in the second half of August 2025
 */
class FilterFactory
{
    const ADAPTER_OPENSSL = 'Openssl';

    /**
     * @param string $adapter
     * @return Decrypt
     */
    public function createDecryptionFilter($adapter = self::ADAPTER_OPENSSL)
    {
        switch ($adapter) {
            case self::ADAPTER_OPENSSL:
                $filter = new Base64DecryptDecorator([
                    'adapter' => 'openssl',
                    'private' => ROOT_PATH . 'config/cert/auth.pem',
                    'package' => true,
                ]);

                $filter->setEnvelopeKey([
                    ROOT_PATH . 'config/cert/auth.crt',
                ]);

                return $filter;
            default:
                throw new InvalidArgumentException(sprintf('Unknown adapter: %s', $adapter));
        }
    }
}
