<?php

namespace Velis\App;

/**
 * @author Jan Małysiak <jan.malysiak@velistech.com>
 */
class PhalconVersion
{
    public const PHALCON4 = 4;
    public const PHALCON5 = 5;

    /**
     * Get exact version id
     * @return int
     */
    public function getVersionId(): int
    {
        if (class_exists(\Phalcon\Support\Version::class)) {
            $version = new \Phalcon\Support\Version();

            return (int) $version->getId();
        } else {
            return (int) \Phalcon\Version::getId();
        }
    }

    /**
     * Get major version number
     * @return int
     */
    public function getMajorVersion(): int
    {
        if ($this->getVersionId() >= 5000000) {
            return self::PHALCON5;
        } else {
            return self::PHALCON4;
        }
    }

    /**
     * Get version string (eg. "1.2.3")
     * @return string
     */
    public function getVersionString(): string
    {
        if (class_exists(\Phalcon\Support\Version::class)) {
            $version = new \Phalcon\Support\Version();

            return $version->get();
        } else {
            return \Phalcon\Version::get();
        }
    }
}
