<?php

namespace Velis\App;

use Phalcon\CLI\Task;
use Velis\Filter;
use Velis\ParametersParser;

/**
 * Base console task
 * @author Olek Procki <olo@velis.pl>
 */
class ConsoleTask extends Task
{
    const WIDTH = 80;

    /**
     * Input parameters filter
     * @var Filter
     */
    protected $_filter;


    /**
     * Task initialization method
     */
    public function initialize()
    {
        global $argv;
        $parser = new ParametersParser();

        $this->_filter = $parser->parse($argv);

        if (!$this->_filter['blank']) {
            echo "\n";
            $this->line();
            echo "Singu Console, copyright (c)2009-" . date('Y') . " Velis\n";
            $this->line();
            echo "\n";
        }
    }


    /**
     * Outputs line
     */
    public function line()
    {
        echo str_repeat('-', self::WIDTH) . "\n";
    }
}
