<?php

namespace Velis\Api;

use Velis\App;
use Velis\Arrays;

/**
 * API Version
 * @author Olek Procki <olo@velis.pl>
 */
class Version
{
    const INITIAL = 1;

    public static function getVersions(): array
    {
        return Arrays::toArray(App::$config->api->versions ?: self::INITIAL);
    }


    public static function validate(string $version): bool
    {
        return in_array($version, self::getVersions());
    }
}
