<?php

namespace Velis\Api\HttpExceptionHandler;

use Throwable;

/**
 * This is a base for HTTP Exceptions (exceptions that should be returned to the user as an API response).
 * All further exceptions should extend this class or at least use its interface.
 * In this class, we can decide whether exception should be logged to our Error Tracking system or not.
 *
 * @author Szymon Janaczek <szymon.janaczek@velistech.com>
 */
interface HttpExceptionInterface
{
    public function __construct(
        $message = '',
        $code = 0,
        ?string $error = null,
        ?array $details = null,
        ?int $httpCode = null,
        Throwable $previous = null
    );

    public function getMessage(): ?string;
    public function getError(): ?string;
    public function getHttpCode(): ?int;
    public function getCode();
    public function getDetails(): ?array;
    /** Decide if we should report the exception to our Error Tracking system. */
    public function shouldReport(): bool;
    /** Report an exception to our Error Tracking system. */
    public function report(?Throwable $originalException = null): void;
}
