<?php

namespace Velis\Api\HttpExceptionHandler\Exception;

use Throwable;
use Velis\Api\HttpExceptionHandler\Map\MapInterface;

/**
 * @author Szymon Janaczek <szymon.janaczek@velistech.com>
 */
class InvalidMapClassException extends \InvalidArgumentException
{
    public function __construct(string $message = "", int $code = 0, ?Throwable $previous = null)
    {
        $mapInterface = MapInterface::class;
        $message ??= "Map class must implement $mapInterface.";

        parent::__construct($message, $code, $previous);
    }
}
