<?php

namespace Velis\Api;

use Throwable;
use Velis\App;

/**
 * API Exception model
 * @author Michał Nosek <michal.nosek@velis.pl>
 */
class Exception extends \Velis\Exception
{
    /**
     * Returns view model with json formatted exception
     *
     */
    public static function toJson(Throwable $e): string
    {
        $errorJson = [
            'message'   => 'An error occurred during execution; please try again later.',
            'error' => '',
            'code' => 0,
            'details' => null
        ];

        $errorJson['error'] = $e->getMessage();
        // It should be logged in the internal log.
        $exceptionJson = [
            'class' => get_class($e),
            'file' => $e->getFile(),
            'line' => $e->getLine(),
            'message' => $e->getMessage()
        ];

        if (App::devMode()) {
            $errorJson['exception'] = $exceptionJson;
        }

        return json_encode($errorJson);
    }
}
