<?php

namespace Velis\Acl;

use Exception;
use Velis\Queue\AbstractJob;
use Velis\User;

/**
 * Priv reload queue
 * @author Damian Kurek <damian.kurek@velis.pl>
 */
class PrivsQueue extends AbstractJob
{
    use RedisSessionTrait;

    /**
     * Performs priv reload
     * @throws Exception
     */
    public function perform(): void
    {
        $this->_reloadPrivs($this->args['user_id']);
    }

    /**
     * Reloads users privs
     * @param array $userIds
     * @throws Exception
     */
    private function _reloadPrivs(array $userIds)
    {
        $session = $this->getSession();
        $users = User::instance($userIds, false, ['user_id', 'node_token']);

        foreach ($users as $user) {
            $session->reloadPrivs($user);
        }
    }

    protected function getQueueName()
    {
        return 'acl';
    }
}
