<?php

namespace Velis\Acl;

use Velis\Model\DataObject;
use Velis\Model\Cacheable;

/**
 * Changelog action types dictionary
 * @author Olek Procki <olo@velis.pl>
 */
class ChangelogAction extends DataObject implements Cacheable
{
    /**
     * Default list order
     * @var string
     */
    protected static $_listDefaultOrder = "changelog_action_id";

    /**
     * Returns related SQL table
     * @return string
     */
    protected function _getTableName()
    {
        return 'acl.changelog_action_tab';
    }

    /**
     * Returns action name in current language
     * @return string
     */
    public function getName()
    {
        return $this->getTranslatedName();
    }
}
