<?php

namespace Velis\VersionControl;

use Velis\Exception as VelisException;

/**
 * @author Szymon Janaczek <szymon.janaczek@velistech.com>
 */
class RevisionStatusHelper
{
    public const TESTS_STATUS_SUCCESS = 1;
    public const TESTS_STATUS_FAILED = -1;
    public const TESTS_STATUS_ONGOING = 0;

    /**
     * @throws VelisException
     */
    public static function getStatusName(?int $status): string
    {
        return match ($status) {
            self::TESTS_STATUS_SUCCESS => 'success',
            self::TESTS_STATUS_FAILED => 'failed',
            self::TESTS_STATUS_ONGOING => 'ongoing',
            null => 'not started',
            default => throw new VelisException('Unknown status'),
        };
    }
}