<?php

namespace Velis\Timezone;

use Velis\Model\DataObject;

/**
 * Available timezones model
 * @author Damian Kurek <damian.kurek@velis.pl>
 */
class AvaliableTimeZone extends DataObject
{
    /**
     * Returns primary key field
     *
     * @return string
     */
    protected function _getPrimaryKeyField()
    {
        return 'name';
    }

    /**
     * Returns name
     *
     * @return string
     */
    public function getName()
    {
        return $this['name'];
    }

    /**
     * {@inheritDoc}
     */
    protected function _getTableName()
    {
        return 'pg_catalog.pg_timezone_names';
    }

    /**
     * Addition is forbidden
     * {@inheritDoc}
     */
    public function add($updateObjectId = false)
    {
        return $this;
    }

    /**
     * Modification is forbidden
     * {@inheritDoc}
     */
    public function modify($checkDiff = false)
    {
        return $this;
    }
}
