<?php

namespace Velis;

use PHPUnit\Framework\TestCase as BaseTestCase;

/**
 * @author Jan Małysiak <jan.malysiak@velistech.com>
 */
class TestCase extends BaseTestCase
{
    /**
     * @param string $pattern
     * @param string $string
     * @param string $message
     * @return void
     */
    public static function assertMatchesRegularExpression($pattern, $string, $message = ''): void
    {
        $parentClass = get_parent_class(self::class);

        if (method_exists($parentClass, 'assertMatchesRegularExpression')) {
            parent::assertMatchesRegularExpression($pattern, $string, $message);
        } else {
            parent::assertRegExp($pattern, $string, $message);
        }
    }

    /**
     * @param string $pattern
     * @param string $string
     * @param string $message
     * @return void
     */
    public static function assertDoesNotMatchRegularExpression($pattern, $string, $message = ''): void
    {
        $parentClass = get_parent_class(self::class);

        if (method_exists($parentClass, 'assertDoesNotMatchRegularExpression')) {
            parent::assertDoesNotMatchRegularExpression($pattern, $string, $message);
        } else {
            parent::assertNotRegExp($pattern, $string, $string);
        }
    }
}
