<?php

namespace Velis\Test\Session;

use PHPUnit\Framework\TestCase;
use Velis\App;
use Velis\Session\Session;
use Velis\Session\SessionFactoryInterface;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class SessionFunctionalTest extends TestCase
{
    /**
     * @var Session
     */
    private $session;

    protected function setUp(): void
    {
        /** @var SessionFactoryInterface $factory */
        $factory = App::$di->get('sessionFactory');
        $this->session = $factory->createFileSession([]);
        $this->session->start();
    }

    /**
     * @runInSeparateProcess
     */
    public function testStartAndDestroy()
    {
        $this->assertTrue($this->session->exists());

        $sessionId = $this->session->getId();
        $this->session->destroy($sessionId);

        $this->assertFalse($this->session->exists());
    }

    /**
     * @runInSeparateProcess
     */
    public function testGetAndSetValues()
    {
        $key = 'key1';

        $this->assertFalse($this->session->has($key));
        $this->assertNull($this->session->get($key));

        $value = 'value1';

        $this->session->set($key, $value);

        $this->assertTrue($this->session->has($key));
        $this->assertEquals($value, $this->session->get($key));

        $this->session->remove($key);

        $this->assertFalse($this->session->has($key));
    }

    /**
     * @runInSeparateProcess
     */
    public function testPropertyAccess()
    {
        $key = 'key2';

        $this->assertFalse(isset($this->session->{$key}));
        $this->assertNull($this->session->{$key});

        $value = 'value2';

        $this->session->{$key} = $value;

        $this->assertTrue(isset($this->session->{$key}));
        $this->assertEquals($value, $this->session->{$key});

        unset($this->session->{$key});

        $this->assertFalse(isset($this->session->{$key}));
    }
}
