<?php

namespace Velis\Test;

use Velis\Db\AnyValue;
use Velis\Db\ExpressionInterface;
use Velis\Db\NullValue;
use Velis\Db\Postgres;
use Velis\TestCase;

class PostgresTest extends TestCase
{
    /**
     * @dataProvider conditionsProvider
     */
    public function testConditions($params, $expectedSql, $expectedParams)
    {
        $conditions = new Postgres();
        $result = $conditions->conditions($params);

        $this->assertEquals($expectedSql, $result);
        $this->assertEquals($expectedParams, $params);
    }

    public function conditionsProvider()
    {

        $expressionInterfaceMock = $this->getMockBuilder(ExpressionInterface::class)
            ->setMethods(['getSql', 'bindParams', 'setFieldName'])
            ->getMock();

        $expressionInterfaceMock->method('getSql')->willReturn('expression_sql');
        $expressionInterfaceMock->method('bindParams')->will(
            $this->returnCallback(
                function (&$params) {
                    $params['expression_param'] = 'value';
                }
            )
        );

        return [
            'empty params' => [
                [],
                '',
                []
            ],
            'scalar condition' => [
                ['field' => 'value'],
                ' AND field = :field',
                ['field' => 'value']
            ],
            'null value condition' => [
                ['field' => null],
                ' AND field IS NULL ',
                []
            ],
            'like condition with wildcards' => [
                ['field' => '%value%'],
                ' AND field ILIKE :field',
                ['field' => '%value%']
            ],
            'array of values condition' => [
                ['field' => ['value1', 'value2']],
                ' AND (field IN( :field_0, :field_1))',
                ['field_0' => 'value1', 'field_1' => 'value2']
            ],
            'array with null values condition' => [
                ['field' => ['value1', new NullValue()]],
                ' AND (field IN( :field_0) OR field IS NULL)',
                ['field_0' => 'value1']
            ],
            'expression interface condition' => [
                ['field' => $expressionInterfaceMock],
                ' AND (expression_sql) ',
                ['expression_param' => 'value']
            ],
            'any value condition' => [
                ['field' => new AnyValue()],
                ' AND field IS NOT NULL ',
                []
            ],
            'empty array condition' => [
                ['field' => []],
                '',
                []
            ],
        ];
    }
}
