<?php

namespace Velis\Test\Mvc\Validators\Rules;

use Velis\Mvc\Validators\Rules\Type;
use PHPUnit\Framework\TestCase;

class TypeTest extends TestCase
{
    public function testStringType()
    {
        $data = [
            'value_1' => null,
            'value_2' => '',
            'value_3' => 'test',
            'value_4' => 32,
            'value_5' => [],
        ];

        $rule = new Type(Type::STRING);
        $this->assertTrue($rule->validate($data, 'value_1'));
        $this->assertTrue($rule->validate($data, 'value_2'));
        $this->assertTrue($rule->validate($data,  'value_3'));
        $this->assertFalse($rule->validate($data, 'value_4'));
        $this->assertFalse($rule->validate($data, 'value_5'));
    }

    public function testNumberType()
    {
        $data = [
            'value_1' => null,
            'value_2' => '',
            'value_3' => 'test',
            'value_4' => 32,
            'value_5' => 0,
            'value_6' => [],
        ];

        $rule = new Type(Type::NUMERIC);
        $this->assertTrue($rule->validate($data, 'value_1'));
        $this->assertTrue($rule->validate($data, 'value_2'));
        $this->assertFalse($rule->validate($data,  'value_3'));
        $this->assertTrue($rule->validate($data, 'value_4'));
        $this->assertTrue($rule->validate($data, 'value_5'));
        $this->assertFalse($rule->validate($data, 'value_6'));
    }
}
