<?php

namespace Velis\Test\Model\DataObject;

use PHPUnit\Framework\TestCase;
use Ticket\Classification;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class CacheTraitTest extends TestCase
{
    /**
     * @param string $class
     * @param int|string|array $objectIds
     *
     * @dataProvider provideTestDataForGetMethod
     */
    public function testGet($class, $objectIds)
    {
        $result = call_user_func([$class, 'get'], $objectIds);

        if (is_array($objectIds)) {
            $this->assertIsArray($result);
            $this->assertInstanceOf($class, reset($result));
        } else {
            $this->assertInstanceOf($class, $result);
            $this->assertEquals($objectIds, $result->id());
        }
    }

    public function provideTestDataForGetMethod()
    {
        return [
            [Classification::class, 'CiaMoveIn'],
            [Classification::class, 'CiaMoveOut'],
        ];
    }
}
