<?php

namespace Velis\Test\Microsoft;

use PHPUnit\Framework\TestCase;
use Velis\Microsoft\Token;

class TokenTest extends TestCase
{
    /**
     * @return void
     * @dataProvider provideDataForIsExpired
     */
    public function testIsExpired(Token $token, bool $expected)
    {
        $this->assertEquals($expected, $token->isExpired());
    }

    public function provideDataForIsExpired(): array
    {
        return [
            [new Token('token', 3600, time() - 3600, 'type'), true],
            [new Token('token', 3600, time() + 3600, 'type'), false],
        ];
    }
}
