<?php

namespace Velis\Test\Lang\LangVariant;

use PHPUnit\Framework\TestCase;
use Velis\Db\Db;
use Velis\Lang\LangVariant;
use Velis\Lang\LangVariant\OverloadedLangs;
use Velis\Test\Lang\LangVariantsFixture;

class OverloadedLangsTest extends TestCase
{
    protected function setUp(): void
    {
        $fixture = new LangVariantsFixture();
        $fixture->fillCache();
    }

    public function testGet()
    {
        $variants = [
            LangVariantsFixture::VARIANT,
            LangVariantsFixture::VARIANT2,
        ];

        $dbMock = $this->createMock(Db::class);

        foreach ($variants as $variantAcro) {
            $variant = new LangVariant($variantAcro);
            $overloadedLangs = new OverloadedLangs($variant, $dbMock);

            foreach ($overloadedLangs->get() as $lang) {
                $this->assertEquals($lang->getKey() . '_' . $variantAcro, $lang->getOverloadedKey());
            }
        }
    }
}
