<?php

namespace Velis\Test\Filter;

use Velis\Filter;
use Velis\TestCase;

class ValueTypeTest extends TestCase
{
    public function testBoolean()
    {
        $testTrue = new Filter([
            'value' => true,
        ]);

        $testFalse = new Filter([
            'value' => false,
        ]);

        $testNotBoolean = new Filter([
            'value' => null,
        ]);

        self::assertTrue($testTrue['value']);
        self::assertFalse($testFalse['value']);
        self::assertIsNotBool($testNotBoolean['value']);
    }

    public function testNull()
    {
        $testNull = new Filter([
            'value' => null,
        ]);

        $testNotNull = new Filter([
            'value' => '',
        ]);

        $testEmpty = new Filter([
            'value' => ' ',
        ]);

        self::assertNull($testNull['value']);
        self::assertNotNull($testNotNull['value']);
        self::assertNotNull($testEmpty['value']);
    }

    public function testInteger()
    {
        $testNegative = new Filter([
            'value' => -1,
        ]);

        $testZero = new Filter([
            'value' => 0,
        ]);

        $testOne = new Filter([
            'value' => 1,
        ]);

        $testNumeric1 = new Filter([
            'value' => '123.5',
        ]);

        $testNumeric2 = new Filter([
            'value' => '123.54',
        ]);

        self::assertIsInt($testNegative['value']);
        self::assertIsInt($testZero['value']);
        self::assertIsInt($testOne['value']);
        self::assertIsNotInt($testNumeric1['value']);
        self::assertIsNotInt($testNumeric2['value']);
    }
}