<?php

namespace Velis\Test\Filter;

use PHPUnit\Framework\TestCase;
use Velis\App;
use Velis\App\PhalconVersion;
use Velis\Filter\ValidatorFactory;

/**
 * @author Jan Małysiak <jan.malysiak@velistech.com>
 */
class ValidatorFactoryTest extends TestCase
{
    private ValidatorFactory $factory;

    /**
     * @return void
     */
    protected function setUp(): void
    {
        $this->factory = new ValidatorFactory();
    }

    /**
     * @param string $type
     * @return void
     *
     * @dataProvider provideTestData
     */
    public function testCreateValidator(string $type)
    {
        $validator = $this->factory->createValidator($type, []);

        if (App::getPhalconMajorVersion() >= PhalconVersion::PHALCON5) {
            $namespace = '\\Phalcon\\Filter\\Validation\\Validator\\';
            $validatorInterface = \Phalcon\Filter\Validation\ValidatorInterface::class;
        } else {
            $namespace = '\\Phalcon\\Validation\\Validator\\';
            $validatorInterface = \Phalcon\Validation\ValidatorInterface::class;
        }

        $fullyQualifiedClassname = $namespace . $type;

        static::assertInstanceOf($validatorInterface, $validator);
        static::assertInstanceOf($fullyQualifiedClassname, $validator);
    }

    /**
     * @return array
     */
    public function provideTestData(): array
    {
        return [
            ['PresenceOf'],
            ['Digit'],
            ['Callback'],
            ['Date'],
            ['Numericality'],
        ];
    }
}
