<?php

namespace Velis\Test\Filter;

use Velis\Filter\IpInNetwork;
use Velis\TestCase;

class IpInNetworkTest extends TestCase
{
    /**
     * @dataProvider getTestCasesForTestCheckMethod
     */
    public function testCheck(string $ip, string $network, bool $result)
    {
        $this->assertEquals($result, IpInNetwork::check($ip, $network));
    }

    public function getTestCasesForTestCheckMethod(): array
    {
        $network1 = '192.168.1.1/32';
        $network2 = '192.168.1.0/24';
        $network3 = '192.168.0.0/16';

        return [
            'match 32' => ['192.168.1.1', $network1, true],
            'not match 32' => ['192.168.1.255', $network1, false],
            'match 24' => ['192.168.1.100', $network2, true],
            'not match 24' => ['192.168.2.1', $network2, false],
            'match 16' => ['192.168.42.42', $network3, true],
            'not match 16' => ['192.169.1.1', $network3, false],
        ];
    }
}
