<?php

namespace Velis\Test\Filesystem\Adapter;

use Gaufrette\FilesystemInterface;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;
use Velis\Filesystem\Adapter\Local;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class LocalTest extends TestCase
{
    /**
     * @var Local
     */
    private $filesystem;


    /**
     * @var MockObject
     */
    private $wrappedFilesystemMock;


    /**
     * {@inheritDoc}
     */
    protected function setUp(): void
    {
        $this->wrappedFilesystemMock = $this->createMock(FilesystemInterface::class);

        $this->filesystem = new Local($this->wrappedFilesystemMock, __DIR__);
    }


    /**
     * @param string $key
     * @param int    $width
     * @param int    $height
     *
     * @dataProvider provideImageFile
     */
    public function testGetImageSize($key, $width, $height)
    {
        $imageSizeArray = $this->filesystem->getImageSize($key);

        $this->assertTrue(is_array($imageSizeArray));
        $this->assertEquals($width, $imageSizeArray[0]);
        $this->assertEquals($height, $imageSizeArray[1]);

        unlink(__DIR__ . '/' . $key);
    }


    /**
     * @return array
     */
    public function provideImageFile()
    {
        $width = 200;
        $height = 100;
        $fileName = md5(uniqid()) . '.jpg';
        $path = __DIR__ . '/' . $fileName;

        $image = imagecreatetruecolor($width, $height);
        imagejpeg($image, $path, 85);

        return [
            [$fileName, $width, $height],
        ];
    }


    public function testListKeys()
    {
        $this->wrappedFilesystemMock->expects($this->never())
            ->method('listKeys');

        $keys = $this->filesystem->listKeys('prefix');

        $this->assertEquals([], $keys);
    }


    public function testSymlink()
    {
        $fileName = 'test.txt';
        $linkName = 'link';

        file_put_contents(__DIR__ . '/' . $fileName, 'test');

        $this->filesystem->symlink($fileName, $linkName);

        $this->assertTrue(is_link(__DIR__ . '/' . $linkName));
        $this->assertEquals(__DIR__ . '/' . $fileName, readlink(__DIR__ . '/' . $linkName));

        unlink(__DIR__ . '/' . $linkName);
        unlink(__DIR__ . '/' . $fileName);
    }
}
