<?php

namespace Velis\Test\Dto\Validators;

use PHPUnit\Framework\TestCase;
use Velis\Dto\Validators\NotEmpty;

class NotEmptyTest extends TestCase
{
    /**
     * @dataProvider provideTestData
     */
    public function testValidate(mixed $input, bool $expectedResult): void
    {
        $validator = new NotEmpty();

        self::assertEquals($expectedResult, $validator->validate($input));
    }

    /**
     * @return array<string,array{0:mixed,1:bool}>
     */
    public function provideTestData(): array
    {
        return [
            'empty string' => ['', false],
            'null' => [null, false],
            'empty array' => [[], false],
            'string' => ['test', true],
            'array' => [[1, 2, 3], true],
        ];
    }
}
