<?php

namespace Velis\Test\Dto\Validators;

use PHPUnit\Framework\TestCase;
use Velis\Dto\Validators\DateFormatValidator;

class DateFormatValidatorTest extends TestCase
{
    /**
     * @dataProvider provideTestData
     */
    public function testValidate(string $dateFormat, string $value, bool $expectedResult): void
    {
        $validator = new DateFormatValidator($dateFormat);
        $actualResult = $validator->validate($value);

        $this->assertEquals($expectedResult, $actualResult);
    }

    /**
     * @return array<array{0: string, 1: string, 2: bool}>>
     */
    public function provideTestData(): array
    {
        return [
            ['Y-m-d', '2024-08-21', true],
            ['Y-m-d', '2024', false],
            ['Y-m-d', '2024-8-21', false],
            ['Y-m-d', '2024-08-21T16:10:00+02:00', false],
            ['Y-m-d', '2024-02-30', false],
            ['Y-m-d', '2024-13-01', false],
            ['c', 'notADate', false],
            ['c', '2024-01-01T00:00:00+00:00', true],
            ['c', '2024-08-21T16:10:00+02:00', true],
            ['c', '2024-08-21', true],
            ['c', '2024-08-21 16:10:00+02:00', true],
            'javascript ISO' => ['c', '2024-01-01T00:00:00.000Z', true],
        ];
    }
}
