<?php

namespace Velis\Test\Dto\Concrete\Casters;

use Attribute;
use DateTime;
use Velis\Dto\Casters\Castable;

#[Attribute]
class CastDateTime implements Castable
{
    public function __construct(private string $format = 'Y-m-d H:i:s')
    {
    }

    public function get($value, $data = null): ?string
    {
        if (!$value instanceof DateTime) {
            return $value;
        }

        return $value->format($this->format);
    }
}
