<?php

namespace Velis\Test\Dto\Casters;

use DateTime;
use PHPUnit\Framework\TestCase;
use Velis\Dto\Casters\CastDateTime;
use Velis\Exception;

/**
 * Class CastDateTimeTest
 * @package Velis\Test\Dto\Casters
 * @author Maciej Borowiec <maciej.borowiec@velistech.com>
 */
class CastDateTimeTest extends TestCase
{
    public function testGetWithNullValue()
    {
        $caster = new CastDateTime();
        $this->assertNull($caster->get(null));
    }

    public function testGetWithInvalidDateFormat()
    {
        $this->expectException(Exception::class);
        $this->expectExceptionMessage('Invalid date format: invalid-date');

        $caster = new CastDateTime();
        $caster->get('invalid-date');
    }

    /**
     * @dataProvider dateProvider
     */
    public function testGetWithVariousDates($input, $expected)
    {
        $caster = new CastDateTime();
        $result = $caster->get($input);
        $this->assertEquals($expected, $result);
    }

    public function dateProvider()
    {
        return [
            ['2023-10-10', '2023-10-10 00:00:00'],
            ['2023-10-10 10:10:10', '2023-10-10 10:10:10'],
            ['2025-01-01T12:00:00.000Z', '2025-01-01 13:00:00'],
            ['2025-01-01T12:00:00+01:00', '2025-01-01 12:00:00'],
            [new DateTime('2023-10-10 10:10:10'), '2023-10-10 10:10:10'],
        ];
    }
}