<?php

namespace Velis\Test\Crypto;

use InvalidArgumentException;
use PHPUnit\Framework\TestCase;
use Velis\Crypto\SignatureGenerator;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class SignatureGeneratorTest extends TestCase
{
    const KEY_PATH = ROOT_PATH . 'config/cert/guestbook.pem';


    /**
     * @var SignatureGenerator
     */
    private $generator;


    /**
     * {@inheritDoc}
     */
    protected function setUp(): void
    {
        $this->generator = new SignatureGenerator(self::KEY_PATH);
    }


    /**
     * @param string $message
     * @param string $expectedSignature
     *
     * @dataProvider provideTestDataForSignMethod
     */
    public function testSign($message, $expectedSignature)
    {
        $actualSignature = $this->generator->sign($message);

        $this->assertEquals($expectedSignature, $actualSignature);
    }


    public function provideTestDataForSignMethod()
    {
        $message = 'dummy message';
        $signature = '';

        $key = openssl_pkey_get_private('file://' . self::KEY_PATH);

        openssl_sign($message, $signature, $key);

        return [
            [$message, base64_encode($signature)],
        ];
    }


    public function testConstructWithInvalidKeyPath()
    {
        $this->expectException(InvalidArgumentException::class);

        $generator = new SignatureGenerator('invalid');
    }
}
