<?php

namespace Velis\Test\Bpm\Ticket;

use PHPUnit\Framework\TestCase;
use ReflectionException;
use Velis\App;
use Velis\Bpm\Ticket\Ticket;
use Velis\Model\DataObject\NoColumnsException;

class TicketTest extends TestCase
{
    /**
     * @param array $data
     * @return void
     * @throws ReflectionException
     * @throws NoColumnsException
     *
     * @dataProvider provideTestDataForAddSimpleMethod
     */
    public function testAddSimple(array $data)
    {
        $ticket = new Ticket($data);
        $ticket->addSimple(true);

        $this->assertNotEmpty($ticket->id());
    }

    /**
     * @return Ticket[][]
     * @throws NoColumnsException
     */
    public function provideTestDataForAddSimpleMethod()
    {
        $query = 'SELECT * FROM app.ticket ORDER BY ticket_id DESC LIMIT 5';
        $tickets = App::$di['db']->getAll($query);

        return array_map(function (array $row) {
            unset($row['ticket_id']);

            return [$row];
        }, $tickets);
    }
}