<?php

namespace Velis\Test\Bpm\Ticket;

use Exception;
use PHPUnit\Framework\TestCase;
use ReflectionException;
use Velis\App;
use Velis\Arrays;
use Velis\Bpm\Ticket\Log;
use Velis\Bpm\Ticket\Post;
use Velis\Model\DataObject\NoColumnsException;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class PostTest extends TestCase
{
    /**
     * @param Post $post
     * @param array $logs
     * @throws Exception
     *
     * @dataProvider provideTestDataForConnectLogsMethod
     * @runInSeparateProcess
     */
    public function testConnectLogs(Post $post, array $logs)
    {
        App::$di['db']->checkDuplicatedQueries(true);

        $post->connectLogs($logs);

        $duplicatedQueries = App::$di['db']->getDuplicatedQueries();

        static::assertEmpty($duplicatedQueries);

        App::$di['db']->checkDuplicatedQueries(false);
    }

    /**
     * @return array[]
     * @throws ReflectionException
     * @throws \Velis\Exception
     * @throws NoColumnsException
     * @throws Exception
     */
    public function provideTestDataForConnectLogsMethod(): array
    {
        $post = Arrays::getFirst(Post::getList(null, null, 'date_entered DESC', 1));

        $logs = [];
        $actions = [
            'AddObserver',
            'RemoveObserver',
        ];

        for ($i = 0; $i < count($actions); $i++) {
            $log = new Log([
                'ticket_log_action_id' => $actions[$i],
                'ticket_id' => $post['ticket_id'],
                'ticket_status_id' => 'Opened',
                'user_id' => 1,
                'direction' => '>',
            ]);
            $log->add(true);
            $logs[] = $log;
        }

        return [
            [$post, [null, null]],
            [$post, [$logs[0], $logs[1]]],
        ];
    }
}
