<?php

namespace Velis\Test\Bpm\Ticket\Mixin;

use PHPUnit\Framework\TestCase;
use Velis\App;
use Velis\Arrays;
use Velis\Bpm\Person;
use Velis\Bpm\Ticket\Mixin\ObserverTrait;
use Velis\Db\Db;
use Velis\User;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class ObserverTraitTest extends TestCase
{
    /**
     * @var ObserverTrait
     */
    private $instance;

    /**
     * {@inheritDoc}
     */
    protected function setUp(): void
    {
        $this->instance = new class {
            use ObserverTrait;

            /**
             * @param int[] $observerIds
             */
            public function setObserverIds($observerIds)
            {
                $this->_observerIds = $observerIds;
            }
        };
    }

    /**
     * @param int[] $observerIds
     * @param string $expectedClass
     *
     * @dataProvider provideObserverIds
     */
    public function testGetObservers($observerIds, $expectedClass)
    {
        $this->instance->setObserverIds($observerIds);

        $observers = $this->instance->getObservers();

        $this->assertIsArray($observers);
        $this->assertEquals(count($observerIds), count($observers));
        $this->assertInstanceOf($expectedClass, Arrays::getFirst($observers));
    }

    public function provideObserverIds()
    {
        /** @var Db $db */
        $db = App::getService('db');

        $userIds = $db->getAll('SELECT u.user_id FROM acl.user_tab u LIMIT 3');
        $personIds = $db->getAll('
            SELECT p.person_id
            FROM app.person p
            WHERE NOT EXISTS (
                SELECT u.user_id FROM acl.user_tab u WHERE u.user_id = p.person_id
            )
            LIMIT 3
        ');

        return [
            'user_ids' => [Arrays::getColumn($userIds, 'user_id'), User::class],
            'person_ids' => [Arrays::getColumn($personIds, 'person_id'), Person::class],
        ];
    }
}
