<?php

namespace Velis\Test;

use PHPUnit\Framework\TestCase;
use Velis\App;
use Velis\User;

/**
 * Velis\App test
 * @author Olek Procki <olo@velis.pl>
 */
class AppTest extends TestCase
{
    /**
     * Tests cache load/save/unset
     */
    public function testCache()
    {
        App::$cache['var'] = 'value';
        $this->assertEquals('value', App::$cache['var']);

        unset(App::$cache['var']);
        $this->assertArrayNotHasKey('var', App::$cache);

        // object cache serialization test
        App::$cache['object'] = App::$user;
        $this->assertInstanceOf(User::class, App::$cache['object']);

        unset(App::$cache['object']);
    }
}
