<?php

namespace Velis\Test\Api;

use Building\Api\V1\TicketListItemNormalizer;
use Building\Api\V1\TicketNormalizer;
use Building\Ticket as BuildingTicket;
use PHPUnit\Framework\TestCase;
use Velis\Api\NormalizerFactory;

/**
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
class NormalizerFactoryTest extends TestCase
{
    /**
     * @var NormalizerFactory
     */
    private $factory;

    protected function setUp(): void
    {
        $this->factory = new NormalizerFactory();
    }

    /**
     * @param $inputDataClass
     * @param $apiVersion
     * @param $context
     * @param $expectedClass
     *
     * @dataProvider provideTestData
     */
    public function testCreateNormalizer($inputDataClass, $apiVersion, $context, $expectedClass)
    {
        if (!class_exists($expectedClass)) {
            $this->markTestSkipped(sprintf('Class %s does not exist', $expectedClass));
        }

        $normalizer = $this->factory->createNormalizer($inputDataClass, $apiVersion, $context);

        $this->assertInstanceOf($expectedClass, $normalizer);
    }

    public function provideTestData()
    {
        return [
            [BuildingTicket::class, '1', NormalizerFactory::CONTEXT_LIST, TicketListItemNormalizer::class],
            [BuildingTicket::class, '1', NormalizerFactory::CONTEXT_SINGLE, TicketNormalizer::class],
        ];
    }
}
