<?php

namespace Velis\Session\Storage;

use Phalcon\Storage\SerializerFactory;
use Phalcon\Storage\Adapter\Redis as RedisAdapter;
use Redis;

/**
 * @author Damian Kurek <damian.kurek@velis.pl>
 */
class Phalcon4RedisStorageAdapter extends RedisAdapter
{

    /**
     * @var string
     */
    private $storagePrefix;

    /**
     * {@inheritdoc}
     */
    public function __construct(SerializerFactory $factory, array $options = [])
    {
        parent::__construct($factory, $options);
        $this->storagePrefix = '_PHCR' . $this->prefix;
    }


    /**
     * {@inheritdoc}
     */
    public function getAdapter()
    {
        if (!$this->adapter) {
            $adapter = parent::getAdapter();
            $adapter->setOption(Redis::OPT_PREFIX, $this->storagePrefix);
            $this->adapter = $adapter;
        }
        return $this->adapter;
    }
}
