<?php

namespace Velis\Session;

use SessionHandlerInterface;

/**
 * SessionInterface
 *
 * @author Jan Małysiak <jan.malysiak@velis.pl>
 */
interface SessionInterface extends SessionHandlerInterface
{
    /**
     * Initialize session
     */
    public function start(): bool;

    /**
     * Checks if session is started
     */
    public function exists(): bool;

    /**
     * Set session id
     */
    public function setId(string $id): void;

    /**
     * Get session id
     */
    public function getId(): string;

    /**
     * Regenerate session's id
     *
     * @param bool $deleteOldSession
     * @return $this
     */
    public function regenerateId(bool $deleteOldSession = true): SessionInterface;

    /**
     * Check if session variable exists
     *
     * @param string $key
     * @return bool
     */
    public function has(string $key): bool;

    /**
     * Set session variable
     */
    public function set(string $key, mixed $value): void;

    /**
     * Return session variable value
     *
     * @param string $key
     * @return mixed
     */
    public function get(string $key);

    /**
     * Remove session variable
     */
    public function remove(string $key): void;

    /**
     * Check if user session exists
     *
     * @param string $sessionId
     * @param int[]|int|null $userIds
     * @return bool
     */
    public function checkSession(string $sessionId, $userIds = null): bool;

    /**
     * Get prefix
     *
     * @return string|null
     */
    public function getPrefix(): ?string;
}
